﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.SessionState;
using System.Text.RegularExpressions;
using DotNet.FrameWork.Common.Encrypt;
using System.Net;
using System.Data.SqlClient;
using System.Data;
using DotNet.FrameWork.Data;


namespace HteamDd.Web.ashx
{
    /// <summary>
    /// Dd_do_register 的摘要说明
    /// </summary>
    public class Dd_do_register : IHttpHandler,IRequiresSessionState
    {
        HaTeam.Dd.BLL.Dd_User bll = new HaTeam.Dd.BLL.Dd_User();
        HaTeam.Dd.Model.Dd_User model = new HaTeam.Dd.Model.Dd_User();
        public void ProcessRequest(HttpContext context)
        {
            if (context.Request["type"] == "Reg")
            {
                User_reg(context);
            }
            else if (context.Request["type"] == "check_blogName")
            {   
                try
                {
                    string blog_name = "select * from Dd_User where User_BlogName=@name";
                    SqlParameter pam = new SqlParameter("@name",SqlDbType.NVarChar,50);
                    pam.Value = context.Request["blogeName"].ToString();            
                    if (DbHelperSQL.GetExists(blog_name, pam))
                    {
                        context.Response.Write("11");
                    }
                    else
                    {
                        context.Response.Write("00");
                    }
                }
                catch
                {
                    context.Response.Write("00");
                }
            }           
        }

        private void User_reg(HttpContext context)
        {
            string blogname = context.Request.Params["blogname"];
            string email = context.Request.Params["email"];
            string password = context.Request.Params["password"];

            model.User_OriginPsw = password;//保存用户的原始密码
            model.User_Passwd = Encrypt.EncryptPassword(password, "MD5");
            model.User_BlogName = blogname;
            model.User_Email = email;
            model.User_ActivCondition = 0;
            model.User_Guid = Convert.ToString(Guid.NewGuid());
            model.User_Datetime = DateTime.Now;
            model.User_UpDatetime = DateTime.Now;
            model.User_Verify = 0;
            model.User_Lock = 0;
            model.User_State = 0;
            model.User_Delete = 0;
            model.User_Count = 0;
            model.User_Order = 0;

            int num = bll.Add(model);
            if (num > 0)
            {
                context.Session["Name"] = blogname;//保存用户的博客名
                context.Session["Password"] = password;//保存用户的密码
                context.Session["PPOEEMAIL"] = email;//保存用户的邮箱账号
                context.Session["Time"] = System.DateTime.Now.ToString();
                context.Session["IP"] = Get_UserIP();
                context.Session["userID"] = num;
                context.Response.Write("1");
            }
            else
            {
                context.Response.Write("0");
            }         
        }

        private string Get_UserIP()
        {
            string client_ip = "";
            string strHostName = Dns.GetHostName(); //得到本机的主机名
            IPHostEntry ipEntry = Dns.GetHostEntry(strHostName); //取得本机IP
            foreach (System.Net.IPAddress ip in ipEntry.AddressList)
            {
                client_ip = ip.ToString();
            }
            return client_ip;
        }

       
        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}